function periodogram2(yt)
%Custom-built function that creates the periodogram for a given signal.
%
%Inputs:
%   yt: signal for which the periodogram is desired.
%
%Copyright 2014: Yuri Shardt
%Distributed as part of the book Statistics for Chemical and Process
%Engineers: A Modern Approach, published by Springer Verlag.

%Checking the data
q=size(yt);
N=length(yt);
if (N<5)
    error('Please make sure that the size of yt is at least 5 samples.');
end
if (N==q(1) && q(2)~=1) || (N==q(2) && q(1)~=1)
    error('Please make sure that yt is either a row or column vector.');
end
y=detrend(yt,0);

%Perform the Fast Fourier Transform
X1=abs(fft(y,N));
X=fftshift(X1);

if (mod(N,2)==0)
    F=[-(N)/2:(N)/2-1]/N;
    count=N/2+1;
else
    F=[-(N-1)/2:(N-1)/2]/N;
    count=(N-1)/2+1;
end

%Creating the plot
plot(F(count:end),X(count:end)/N*2,'-k')
xlabel(['Frequency, $f$, (cycles/sample)'],'interpreter','latex'),ylabel('Amplitude, $|y|$','interpreter','latex')

end